using UnityEngine;

public class PlayerScript : MonoBehaviour {
	public Country country;
	public GameObject canonPrefab;
	private GameObject canon;
	public float totalSurface;
	public float damagedSurface;
	
	private float lastAlpha = 0.0f;
	private float lastBetha = 25.0f;
	
	public void showCanon()
	{
		LaunchSites sites = transform.Find("/LaunchSites").GetComponent(typeof(LaunchSites)) as LaunchSites;
		Transform tr = sites.sites[(int)country];
		canon  = (GameObject)Instantiate(canonPrefab, tr.position, tr.rotation);
		CanonScript c = canon.GetComponent(typeof(CanonScript)) as CanonScript;
		c.alpha = lastAlpha;
		c.betha = lastBetha;
		Camera.main.SendMessage ("FocusOnto", tr);
	}
	
	public void hideCanon()
	{
		if (canon) {
			CanonScript c = canon.GetComponent(typeof(CanonScript)) as CanonScript;
			lastAlpha = c.alpha;
			lastBetha = c.betha;
			Destroy(canon);
		}
	}
}
